<?php
require('fpdf/fpdf.php');
include('includes/db.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $aidedSFS = $_POST['aidedSFS'];
    $classAndDepartment = $_POST['classAndDepartment'];
    $address = $_POST['address'];
    $mobileNumber = $_POST['mobileNumber'];
    $email = $_POST['email'];
    $fathersName = $_POST['fathersName'];
    $fathersOccupation = $_POST['fathersOccupation'];
    $mothersName = $_POST['mothersName'];
    $mothersOccupation = $_POST['mothersOccupation'];
    $guardiansName = $_POST['guardiansName'];
    $guardiansOccupation = $_POST['guardiansOccupation'];
    $annualIncome = $_POST['annualIncome'];
    $contactNumber = $_POST['contactNumber'];

    // Insert data into the database
    $stmt = $conn->prepare("INSERT INTO applications (name, aidedSFS, classAndDepartment, address, mobileNumber, email, fathersName, fathersOccupation, mothersName, mothersOccupation, guardiansName, guardiansOccupation, annualIncome, contactNumber) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param('ssssssssssssss', $name, $aidedSFS, $classAndDepartment, $address, $mobileNumber, $email, $fathersName, $fathersOccupation, $mothersName, $mothersOccupation, $guardiansName, $guardiansOccupation, $annualIncome, $contactNumber);
    $stmt->execute();
    $stmt->close();

    // Generate PDF
    $pdf = new FPDF();
    $pdf->AddPage();
    $pdf->SetFont('Arial', 'B', 16);
    $pdf->Cell(0, 10, 'Application Form', 0, 1, 'C');
    $pdf->SetFont('Arial', '', 12);
    $pdf->Cell(0, 10, 'Name: ' . $name, 0, 1);
    $pdf->Cell(0, 10, 'Aided/SFS: ' . $aidedSFS, 0, 1);
    $pdf->Cell(0, 10, 'Class & Department: ' . $classAndDepartment, 0, 1);
    $pdf->Cell(0, 10, 'Address: ' . $address, 0, 1);
    $pdf->Cell(0, 10, 'Mobile Number: ' . $mobileNumber, 0, 1);
    $pdf->Cell(0, 10, 'Email ID: ' . $email, 0, 1);
    $pdf->Cell(0, 10, 'Father\'s Name: ' . $fathersName, 0, 1);
    $pdf->Cell(0, 10, 'Father\'s Occupation: ' . $fathersOccupation, 0, 1);
    $pdf->Cell(0, 10, 'Mother\'s Name: ' . $mothersName, 0, 1);
    $pdf->Cell(0, 10, 'Mother\'s Occupation: ' . $mothersOccupation, 0, 1);
    $pdf->Cell(0, 10, 'Guardian\'s Name: ' . $guardiansName, 0, 1);
    $pdf->Cell(0, 10, 'Guardian\'s Occupation: ' . $guardiansOccupation, 0, 1);
    $pdf->Cell(0, 10, 'Annual Income: ' . $annualIncome, 0, 1);
    $pdf->Cell(0, 10, 'Contact Number: ' . $contactNumber, 0, 1);

    $pdf->Ln(20);
    $pdf->Cell(0, 10, 'Signature:', 0, 1);
    $pdf->Cell(0, 10, 'Date:', 0, 1);
    $pdf->Cell(0, 10, 'Contact:', 0, 1);
    $pdf->Cell(0, 10, 'Dr. PHEBE AGNUS (Aided) - 9962318301', 0, 1);
    $pdf->Cell(0, 10, 'Prof. D RAMALA SINGH (SFS) - 9840133196', 0, 1);

    $pdf->Ln(20);
    $pdf->Cell(0, 10, 'Recommended by the head of the department', 0, 1);
    $pdf->Cell(0, 10, 'Signature:', 0, 1);
    $pdf->Cell(0, 10, 'Date:', 0, 1);

    $pdf->Output('D', 'Application_Form_' . $name . '.pdf');
}
?>
